package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.entity.Torrent;
import com.example.g8backend.mapper.TorrentMapper;
import com.example.g8backend.service.ITorrentService;
import com.example.g8backend.util.TorrentUtil;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

@Service
public class TorrentServiceImpl  extends ServiceImpl<TorrentMapper, Torrent> implements ITorrentService {
    @Resource
    private TorrentMapper torrentMapper;

    String tracker = "http://127.0.0.1:8080/tracker/announce/";

    @Override
    public Torrent handleTorrentUpload(File file, Long userId, String passkey) throws IOException, IllegalArgumentException {
        // 修改 announce 字段
        byte[] modifiedBytes = TorrentUtil.injectTracker(file, tracker + passkey);

        // 计算 info_hash
        String infoHash = TorrentUtil.getInfoHash(file);

        // 文件大小（以MB为单位）
        double fileSize = file.length() / 1024.0 / 1024.0;

        // 保存新的种子文件（可选）
        File outputDir = new File("uploaded-torrents");
        if (!outputDir.exists()) {
            if (!outputDir.mkdirs()){
                throw new IOException("Failed to create directory: " + outputDir.getAbsolutePath());
            }
        }

        File savedFile = new File(outputDir, file.getName());
        try (FileOutputStream fos = new FileOutputStream(savedFile)) {
            fos.write(modifiedBytes);
        }

        // 插入数据库
        torrentMapper.insertTorrent(userId, file.getName(), infoHash, fileSize);

        // 构建返回实体
        Torrent torrent = new Torrent();
        torrent.setUserId(userId);
        torrent.setTorrentName(file.getName());
        torrent.setInfoHash(infoHash);
        torrent.setFileSize(fileSize);
        return torrent;
    }

    @Override
    public File handleTorrentDownload(Torrent torrent, String passkey) throws IOException {
        File torrentFile = new File("uploaded-torrents/" + torrent.getTorrentName());
        byte[] modifiedBytes = TorrentUtil.injectTracker(torrentFile, tracker + passkey);

        File tempFile = File.createTempFile("user_torrent_", ".torrent");
        try (FileOutputStream fos = new FileOutputStream(tempFile)) {
            fos.write(modifiedBytes);
        }
        return tempFile;
    }

    @Override
    public Torrent findByInfoHash(String infoHash){
        return torrentMapper.getTorrentByInfoHash(infoHash);
    }

    @Override
    public Torrent findByTorrentId(Long torrentId){
        return torrentMapper.getTorrentByTorrentId(torrentId);
    }
}
