package com.example.g8backend.controller;

import com.example.g8backend.dto.AnnounceRequestDTO;
import com.example.g8backend.dto.AnnounceResponseDTO;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import com.example.g8backend.service.ITrackerService;

@RestController
@RequestMapping("/tracker")
public class TrackerController {

    @Autowired
    private ITrackerService trackerService;

    @GetMapping("/announce/{passkey}")
    public ResponseEntity<AnnounceResponseDTO> getAnnouncements(
            HttpServletRequest request,
            @RequestParam("info_hash") String infoHash,
            @RequestParam("peer_id") String peerId,
            @RequestParam("port") int port,
            @RequestParam("uploaded") double uploaded,
            @RequestParam("downloaded") double downloaded,
            @RequestParam(value = "event", required = false) String event,
            @RequestParam(value = "left", required = false) Double left,
            @RequestParam(value = "compact", required = false) Integer compact,
            @PathVariable String passkey) {

        AnnounceRequestDTO requestDTO = new AnnounceRequestDTO();
        requestDTO.setPasskey(passkey);
        requestDTO.setInfoHash(infoHash);
        requestDTO.setPeerId(peerId);
        requestDTO.setPort(port);
        requestDTO.setUploaded(uploaded);
        requestDTO.setDownloaded(downloaded);
        requestDTO.setEvent(event);
        requestDTO.setLeft(left);
        requestDTO.setCompact(compact);

        String ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        requestDTO.setIp(ipAddress.split(",")[0]);
        return ResponseEntity.ok(trackerService.handleAnnounce(requestDTO));
    }
}
