package com.example.g8backend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.Follow;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface FollowMapper extends BaseMapper<Follow> {
    @Delete("DELETE FROM user_follows WHERE follower_id=#{followerId} AND followed_id=#{followedId}")
    int deleteByPair(@Param("followerId") Long followerId, @Param("followedId") Long followedId);

    @Select("SELECT followed_id FROM user_follows WHERE follower_id = #{userId}")
    List<Long> selectFollowings(Long userId);

    @Select("SELECT follower_id FROM user_follows WHERE followed_id = #{userId}")
    List<Long> selectFollowers(Long userId);
}
