package com.example.g8backend.service.impl;

import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.IForgotPasswordService;
import com.example.g8backend.util.mailUtil;  // 导入 mailUtil
import jakarta.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.Random;
import java.util.concurrent.TimeUnit;

@Service
public class ForgotPasswordServiceImpl implements IForgotPasswordService {

    @Resource
    private UserMapper userMapper;

    @Resource
    private RedisTemplate<String, String> redisTemplate;

    @Resource
    private PasswordEncoder passwordEncoder;

    @Resource
    private mailUtil mailUtil;  // 注入 mailUtil

    @Override
    public void sendCodeToEmail(String username) {
        User user = userMapper.getUserByName(username);
        if (user == null || user.getEmail() == null) throw new RuntimeException("用户不存在或未绑定邮箱");

        // 生成验证码
        String code = String.valueOf(100000 + new Random().nextInt(900000));

        // 将验证码存储到 Redis
        redisTemplate.opsForValue().set("reset_code:" + username, code, 10, TimeUnit.MINUTES);

        // 使用 mailUtil 发送邮件
        String subject = "重置密码验证码";
        String message = "您的验证码为：" + code + "，10分钟内有效。";
        mailUtil.sendMail(user.getEmail(), subject, message);  // 发送邮件
    }

    @Override
    public boolean resetPassword(String username, String code, String newPassword) {
        String key = "reset_code:" + username;
        String realCode = redisTemplate.opsForValue().get(key);

        if (realCode == null || !realCode.equals(code)) throw new RuntimeException("验证码错误或已过期");

        User user = userMapper.getUserByName(username);
        if (user == null) throw new RuntimeException("用户不存在");

        // 更新密码
        user.setPassword(passwordEncoder.encode(newPassword));

        // 删除 Redis 中存储的验证码
        redisTemplate.delete(key);

        // 更新用户信息
        return userMapper.updateById(user) > 0;
    }
}
