package com.example.g8backend.service;

import com.example.g8backend.entity.Comment;
import com.example.g8backend.mapper.CommentMapper;
import com.example.g8backend.service.impl.CommentServiceImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

@ExtendWith(SpringExtension.class)
@DisplayName("评论服务测试")
class CommentServiceTest {

    @Mock
    private CommentMapper commentMapper;

    @InjectMocks
    private CommentServiceImpl commentService;

    private Comment testComment;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        testComment = createTestComment();
    }

    private Comment createTestComment() {
        Comment comment = new Comment();
        comment.setCommentId(1L);
        comment.setPostId(1L);
        comment.setUserId(1L);
        comment.setContent("测试评论内容");
        return comment;
    }


    @Test
    @DisplayName("获取评论-根据帖子ID返回评论列表")
    void getCommentsByPostId_ShouldReturnComments() {
        // Arrange
        List<Comment> expectedComments = Arrays.asList(testComment);
        when(commentMapper.findTopLevelCommentsByPostId(1L)).thenReturn(expectedComments);

        // Act
        List<Comment> result = commentService.getCommentsByPostId(1L);

        // Assert
        assertNotNull(result);
        assertFalse(result.isEmpty());
        assertEquals(testComment.getCommentId(), result.get(0).getCommentId());
        verify(commentMapper).findTopLevelCommentsByPostId(1L);
    }

    @Test
    @DisplayName("删除评论-成功")
    void deleteComment_ShouldSucceed() {
        // Arrange
        when(commentMapper.deleteById(1L)).thenReturn(1);

        // Act
        boolean result = commentService.deleteComment(1L);

        // Assert
        assertTrue(result);
        verify(commentMapper).deleteById(1L);
    }

    @Test
    @DisplayName("获取评论-没有评论")
    void getCommentsByPostId_WhenNoComments_ShouldReturnEmptyList() {
        // Arrange
        when(commentMapper.findTopLevelCommentsByPostId(999L)).thenReturn(Arrays.asList());

        // Act
        List<Comment> result = commentService.getCommentsByPostId(999L);

        // Assert
        assertNotNull(result);
        assertTrue(result.isEmpty());
        verify(commentMapper).findTopLevelCommentsByPostId(999L);
    }

    @Test
    @DisplayName("获取评论-根据父评论ID返回子评论")
    void getReplies_ShouldReturnReplies() {
        // Arrange
        List<Comment> expectedReplies = Arrays.asList(testComment);
        when(commentMapper.findRepliesByParentCommentId(1L)).thenReturn(expectedReplies);

        // Act
        List<Comment> result = commentService.getReplies(1L, 5);

        // Assert
        assertNotNull(result);
        assertFalse(result.isEmpty());
        assertEquals(testComment.getCommentId(), result.get(0).getCommentId());
        verify(commentMapper).findRepliesByParentCommentId(1L);
    }

}
