package com.example.g8backend.service;

import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.impl.UserServiceImpl;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
class UserServiceTest {

    @Mock
    private UserMapper userMapper;

    @InjectMocks
    private UserServiceImpl userService;

    @Test
    void getUserByName_ShouldReturnUser_WhenNameExists() {
        // 准备测试数据
        String name = "Alice";
        User expectedUser = new User();
        expectedUser.setUserName(name);

        // 模拟Mapper行为
        when(userMapper.getUserByName(name)).thenReturn(expectedUser);

        // 调用被测试方法
        User actualUser = userService.getUserByName(name);

        // 验证结果
        assertEquals(expectedUser, actualUser);
        verify(userMapper, times(1)).getUserByName(name);
    }

    @Test
    void getUserByEmail_ShouldReturnUser_WhenEmailExists() {
        String email = "xxi13552467509@163.com";
        User expectedUser = new User();
        expectedUser.setEmail(email);

        when(userMapper.getUserByEmail(email)).thenReturn(expectedUser);

        User actualUser = userService.getUserByEmail(email);

        assertEquals(expectedUser, actualUser);
        verify(userMapper, times(1)).getUserByEmail(email);
    }

    @Test
    void getUserByPasskey_ShouldReturnUser_WhenPasskeyExists() {
        String passkey = "secret123";
        User expectedUser = new User();
        expectedUser.setPasskey(passkey);

        when(userMapper.getUserByPasskey(passkey)).thenReturn(expectedUser);

        User actualUser = userService.getUserByPasskey(passkey);

        assertEquals(expectedUser, actualUser);
        verify(userMapper, times(1)).getUserByPasskey(passkey);
    }

    @Test
    void getUserByName_ShouldReturnNull_WhenNameNotExists() {
        String name = "Unknown";
        when(userMapper.getUserByName(name)).thenReturn(null);

        User result = userService.getUserByName(name);

        assertNull(result);
        verify(userMapper, times(1)).getUserByName(name);
    }
}