package com.example.g8backend.controller;
import com.example.g8backend.dto.TorrentRecommendationDTO;
import com.example.g8backend.dto.ApiResponse;
import com.example.g8backend.service.ITorrentRecommendationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/torrent")
public class TorrentRecommendationController {

    @Autowired
    private ITorrentRecommendationService recommendationService;
    @GetMapping("/recommend-cold")
    public ApiResponse<List<TorrentRecommendationDTO>> recommendColdTorrents(
            @RequestParam(name = "limit", defaultValue = "10") int limit) {
        List<TorrentRecommendationDTO> result = recommendationService.getColdTorrentRecommendations(limit);
        return ApiResponse.success(result);
    }
}
