package com.example.g8backend.mapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.Post;
import com.example.g8backend.entity.PostTag;
import com.example.g8backend.entity.Tag;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import java.util.List;
@Mapper
public interface PostTagMapper extends BaseMapper<PostTag> {
    List<Post> getPostsByTagIds(@Param("tagIds") Long[] tagIds);
    List<Tag> getTagsByPostId(@Param("postId") Long postId);
    int deleteByIds(@Param("postId") Long postId, @Param("tagId") Long tagId);
    @Select("SELECT tag_id FROM post_tag WHERE post_id = #{postId}")
    List<Long> findTagIdsByPostId(Long postId);
    @Select({
            "<script>",
            "SELECT post_id FROM post_tag",
            "WHERE tag_id IN",
            "<foreach item='tagId' collection='tagIds' open='(' separator=',' close=')'>",
            "#{tagId}",
            "</foreach>",
            "</script>"
    })
    List<Long> findPostIdsByTagIds(@Param("tagIds") List<Long> tagIds);
}