package com.example.g8backend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.Torrent;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import java.util.List;


@Mapper
public interface TorrentMapper extends BaseMapper<Torrent> {
    void insertTorrent (@Param("userId") Long userId,
                       @Param("torrentName") String torrentName,
                       @Param("filePath") String filePath,
                       @Param("infoHash") String infoHash,
                       @Param("fileSize") Double fileSize);
    Torrent getTorrentByInfoHash (@Param("infoHash") String infoHash);
    Torrent getTorrentByTorrentId (@Param("torrentId") Long torrentId);
    List<Torrent> selectByInfoHashList(@Param("infoHashes") List<String> infoHashes);
    // Mapper接口，MyBatis注解或XML配置均可
    int updateIsRareByInfoHash(@Param("infoHash") String infoHash, @Param("israre") int israre);

}
