package com.example.g8backend.mapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.UserTagPreference;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import java.util.List;
public interface UserTagPreferenceMapper extends BaseMapper<UserTagPreference> {
    /**
     * 插入或更新用户标签偏好权重
     */
    @Update("INSERT INTO user_tag_preference (user_id, tag_id, weight) " +
            "VALUES (#{userId}, #{tagId}, #{increment}) " +
            "ON DUPLICATE KEY UPDATE weight = weight + #{increment}")
    void insertOrUpdateWeight(
            @Param("userId") Long userId,
            @Param("tagId") Long tagId,
            @Param("increment") Double increment
    );
    @Select("SELECT * FROM user_tag_preference WHERE user_id = #{userId}")
    List<UserTagPreference> selectByUserId(@Param("userId") Long userId);
}