package com.example.g8backend.scheduler;

import com.example.g8backend.dto.TorrentRecommendationDTO;
import com.example.g8backend.service.ITorrentRecommendationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ColdTorrentRefreshScheduler {

    private final ITorrentRecommendationService recommendationService;

    @Autowired
    public ColdTorrentRefreshScheduler(ITorrentRecommendationService recommendationService) {
        this.recommendationService = recommendationService;
    }

    @Scheduled(fixedRate = 5000)
    public void refreshColdTorrents() {
        // 自动刷新数据库中的israre字段，保持前10个冷门标记
        recommendationService.refreshIsRareField(10);

        // 获取刷新后的冷门数据返回（可选打印日志）
        List<TorrentRecommendationDTO> coldTorrents = recommendationService.getColdTorrentRecommendations(10);
        System.out.println("【定时任务】刷新冷门种子列表，条数：" + coldTorrents.size());
        coldTorrents.forEach(System.out::println);
    }
}

