package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.dto.ApiResponse;
import com.example.g8backend.entity.Post;
import com.example.g8backend.entity.PostRating;
import com.example.g8backend.mapper.PostMapper;
import com.example.g8backend.mapper.PostRatingMapper;
import com.example.g8backend.service.IPostRatingService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RequiredArgsConstructor
public class PostRatingServiceImpl extends ServiceImpl<PostRatingMapper, PostRating> implements IPostRatingService {

    private final PostRatingMapper postRatingMapper;
    private final PostMapper postMapper;

    @Override
    @Transactional
    public void ratePost(Long userId, Long postId, Integer rating) {
        // 校验评分范围
        if (rating < 1 || rating > 5) {
            throw new IllegalArgumentException("评分值必须在1到5之间");
        }

        // 插入或更新评分记录
        PostRating postRating = new PostRating();
        postRating.setUserId(userId);
        postRating.setPostId(postId);
        postRating.setRating(rating);
        boolean success = postRatingMapper.insertOrUpdate(postRating);

        if (!success) {
            throw new RuntimeException("评分操作失败");
        }

        // 更新统计信息
        Double avgRating = postRatingMapper.calculateAverageRating(postId);
        Integer count = postRatingMapper.getRatingCount(postId);
        postMapper.updateRatingStats(postId, avgRating, count);
    }

    @Override
    public Double getAverageRating(Long postId) {
        return postRatingMapper.calculateAverageRating(postId);
    }

    @Override
    public Long getRatingUserCount(Long postId) {
        return postRatingMapper.selectRatingUserCount(postId);
    }
}