package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.example.g8backend.entity.Report;
import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.ReportMapper;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.IReportService;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.time.LocalDateTime;
import java.util.List;

@Service
@RequiredArgsConstructor
public class ReportServiceImpl implements IReportService {
    private final ReportMapper reportMapper;
    private final UserMapper userMapper; // 新增 UserMapper 用于获取用户角色

    @Override
    @Transactional
    public boolean submitReport(Long userId, Long postId, String reason) {
        // 检查是否已存在未处理的举报
        Long count = reportMapper.selectCount(
                new QueryWrapper<Report>()
                        .eq("user_id", userId)
                        .eq("post_id", postId)
                        .eq("status", "pending")
        );
        if (count > 0) {
            throw new IllegalArgumentException("您已举报过该帖子，请勿重复提交");
        }

        // 创建举报记录
        Report report = new Report();
        report.setPostId(postId);
        report.setUserId(userId);
        report.setReason(reason);
        report.setStatus("pending");
        report.setCreatedAt(LocalDateTime.now());
        return reportMapper.insert(report) > 0;
    }

    @Override
    @Transactional
    public boolean resolveReport(Long reportId, Long adminUserId, String status, String notes) {
        User adminUser = userMapper.selectById(adminUserId);
        if (adminUser == null || !"ADMIN".equals(adminUser.getRole())) {
            throw new AccessDeniedException("无权执行此操作：非管理员用户");
        }

        Report report = reportMapper.selectById(reportId);
        if (report == null) {
            throw new IllegalArgumentException("举报记录不存在");
        }
        report.setStatus(status);
        report.setResolvedBy(adminUserId);
        report.setResolvedAt(LocalDateTime.now());
        report.setResolutionNotes(notes);
        return reportMapper.updateById(report) > 0;
    }

    @Override
    public List<Report> getReports(String status, Long requesterUserId) {
        User requester = userMapper.selectById(requesterUserId);
        if (requester == null || !"ADMIN".equals(requester.getRole())) {
            throw new AccessDeniedException("无权查看举报记录：非管理员用户");
        }
        return reportMapper.selectList(
                new QueryWrapper<Report>().eq("status", status)
        );
    }
}