package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.example.g8backend.entity.User;
import com.example.g8backend.entity.UserSignin;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.mapper.UserSigninMapper;
import com.example.g8backend.service.ISigningService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.time.LocalDate;
import java.util.List;

@Service
@RequiredArgsConstructor
public class SigninServiceImpl implements ISigningService{
    private final UserMapper userMapper;
    private final UserSigninMapper userSigninMapper;

    @Override
    @Transactional
    public boolean signIn(Long userId) {
        LocalDate today = LocalDate.now();
        String todayStr = today.toString();

        // 检查今日是否已签到
        if (userSigninMapper.existsByUserIdAndDate(userId, todayStr)) {
            return false; // 已签到
        }

        // 插入签到记录
        UserSignin signin = new UserSignin();
        signin.setUserId(userId);
        signin.setSigninDate(today);
        userSigninMapper.insert(signin);

        // 更新用户信息
        User user = userMapper.selectById(userId);
        user.setSigninCount(user.getSigninCount() + 1);
        user.setLastSigninDate(today);

        // 根据签到次数升级等级 默认lv1 三次签到lv2 十次签到lv3
        if (user.getSigninCount() >= 10) {
            user.setUserLevel("lv3");
        } else if (user.getSigninCount() >= 3) {
            user.setUserLevel("lv2");
        }

        userMapper.updateById(user);
        return true;
    }

    @Override
    public List<UserSignin> getSigninsByDateRange(Long userId, LocalDate startDate, LocalDate endDate) {
        QueryWrapper<UserSignin> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId)
                .between("signin_date", startDate, endDate)
                .orderByAsc("signin_date");
        return userSigninMapper.selectList(queryWrapper);
    }
}