package com.example.g8backend.service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import jakarta.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;


@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements IUserService {
    @Resource
    private UserMapper userMapper; // 手动注入 UserMapper

    @Autowired
    private PasswordEncoder passwordEncoder;

    @Override
    public User getUserByName(String name) { return userMapper.getUserByName(name);} // 调用 UserMapper 的自定义 SQL

    @Override
    public User getUserByEmail(String email) { return userMapper.getUserByEmail(email);}

    @Override
    public void registerUser(User user) {
        String password = user.getPassword(); // 获取密码
        String encodedPassword = passwordEncoder.encode(password); // 加密密码
        user.setPassword(encodedPassword);
        System.out.println(user.getPassword());
        userMapper.insert(user); // 调用 UserMapper 的 insert 方法
    }
}
