package com.example.g8backend.util;

import io.jsonwebtoken.*;
import org.springframework.stereotype.Component;
import javax.crypto.SecretKey;
import java.util.Date;

@Component
public class JwtUtil {

    private final SecretKey secretKey;
    private final long expirationMs;

    public JwtUtil(SecretKey secretKey) {
        this.secretKey = secretKey;
        this.expirationMs = 3600_000; // 1小时
    }

    // 生成 JWT Token
    public String generateToken(String username) {
        Date now = new Date();
        Date expiryDate = new Date(now.getTime() + expirationMs);

        return Jwts.builder()
                .subject(username)
                .issuedAt(now)
                .expiration(expiryDate)
                .signWith(secretKey, Jwts.SIG.HS256)
                .compact();
    }

    // 验证Token并解析用户名
    public String validateTokenAndGetUsername(String token) {
        try {
            Jws<Claims> claims = Jwts.parser()
                    .verifyWith(secretKey)
                    .build()
                    .parseSignedClaims(token);

            return claims.getPayload().getSubject();
        } catch (JwtException e) {
            throw new RuntimeException("Token无效或过期", e);
        }
    }
}
