CREATE TABLE IF NOT EXISTS `users` (
  user_id INT AUTO_INCREMENT PRIMARY KEY,
  user_name VARCHAR(255) NOT NULL,
  password VARCHAR(255) NOT NULL,
  email VARCHAR(255) NOT NULL UNIQUE
);

CREATE TABLE IF NOT EXISTS `torrents` (
    torrent_id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    torrent_name VARCHAR(255) NOT NULL,
    info_hash VARCHAR(255) NOT NULL,
    file_size FLOAT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(user_id)
);

CREATE TABLE IF NOT EXISTS `peers` (
  user_id INT NOT NULL,
  torrent_id INT NOT NULL,
  peer_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
  ip_address VARCHAR(128) NOT NULL,
  port INT NOT NULL,
  uploaded FLOAT NOT NULL,
  downloaded FLOAT NOT NULL,
  FOREIGN KEY (user_id) REFERENCES users(user_id),
  FOREIGN KEY (torrent_id) REFERENCES torrents(torrent_id)
);
