package com.example.g8backend.controller;

import com.example.g8backend.dto.ApiResponse;
import com.example.g8backend.dto.ForgotPasswordDTO;
import com.example.g8backend.dto.ResetPasswordDTO;
import com.example.g8backend.service.IForgotPasswordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/forgot-password")
public class ForgotPasswordController {

    @Autowired
    private IForgotPasswordService forgotPasswordService;

    @PostMapping("/send-code")
    public ApiResponse<String> sendCode(@RequestBody ForgotPasswordDTO dto) {
        forgotPasswordService.sendCodeToEmail(dto.getUsername());
        return ApiResponse.success("验证码已发送到注册邮箱");
    }

    @PostMapping("/reset")
    public ApiResponse<String> resetPassword(@RequestBody ResetPasswordDTO dto) {
        forgotPasswordService.resetPassword(dto.getUsername(), dto.getCode(), dto.getNewPassword());
        return ApiResponse.success("密码重置成功");
    }
}
