package com.example.g8backend.controller;

import com.example.g8backend.dto.PasswordChangeDTO;
import com.example.g8backend.dto.ApiResponse;
import com.example.g8backend.service.IUserSecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/user/security")
public class UserSecurityController {

    @Autowired
    private IUserSecurityService userSecurityService;

    @PutMapping("/change-password")
    public ApiResponse<String> changePassword(@RequestBody PasswordChangeDTO dto) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Long userId = (Long) authentication.getPrincipal();

        // 调用服务层进行密码修改
        userSecurityService.changePassword(userId, dto.getOldPassword(), dto.getNewPassword());

        // 返回统一的成功响应
        return ApiResponse.success("密码修改成功");
    }
}
