package com.example.g8backend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.User;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

@Mapper
public interface UserMapper extends BaseMapper<User> {
    User getUserByName(@Param("userName") String userName);
    User getUserByEmail(@Param("email") String email);
    User getUserByPasskey(@Param("passkey") String passkey);

    @Select("SELECT * FROM users WHERE user_name = #{name}")
    User selectByUserName(@Param("name") String name);

    @Update("UPDATE users SET user_level = #{userLevel} WHERE user_id = #{userId}")
    int updateUserLevel(@Param("userId") Long userId, @Param("userLevel") String userLevel);
}
