package com.example.g8backend.service.impl;

import com.example.g8backend.entity.Peer;
import com.example.g8backend.mapper.PeerMapper;
import com.example.g8backend.service.PeerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class PeerServiceImpl implements PeerService {

    private final PeerMapper peerMapper;

    @Autowired
    public PeerServiceImpl(PeerMapper peerMapper) {
        this.peerMapper = peerMapper;
    }

    @Override
    public Peer getPeerByPK(String peerId, String infoHash, String passkey) {
        return peerMapper.getPeerByPK(peerId, infoHash, passkey);
    }

    @Override
    public List<Peer> getPeerByInfoHashAndPeerId(String infoHash, String peerId) {
        return peerMapper.getPeerByInfoHashAndPeerId(infoHash, peerId);
    }

    @Override
    public void updatePeer(String passkey, String peerId, String infoHash, double uploaded, double downloaded) {
        peerMapper.updatePeer(passkey, peerId, infoHash, uploaded, downloaded);
    }
}
