package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.entity.Torrent;
import com.example.g8backend.mapper.TorrentMapper;
import com.example.g8backend.service.ITorrentService;
import com.example.g8backend.service.IUserStatsService;
import com.example.g8backend.util.TorrentUtil;
import jakarta.annotation.Resource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

@Service
public class TorrentServiceImpl extends ServiceImpl<TorrentMapper, Torrent> implements ITorrentService {

    @Resource
    private TorrentMapper torrentMapper;

    @Resource
    private IUserStatsService userStatsService;

    private final String tracker = "http://127.0.0.1:8080/tracker/announce/";

    @Override
    public Torrent handleTorrentUpload(File file, String fileName, Long userId, String passkey) throws IOException {
        // 注入 tracker
        byte[] modifiedBytes = TorrentUtil.injectTracker(file, tracker + passkey);

        // 获取 infoHash
        String infoHash = TorrentUtil.getInfoHash(file);

        // 计算大小（MB）
        double fileSize = file.length() / 1024.0 / 1024.0;

        // 保存修改后的文件
        File outputDir = new File("uploaded-torrents");
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IOException("Failed to create directory: " + outputDir.getAbsolutePath());
        }

        File savedFile = new File(outputDir, file.getName());
        try (FileOutputStream fos = new FileOutputStream(savedFile)) {
            fos.write(modifiedBytes);
        }

        // 插入数据库
        Torrent newTorrent = new Torrent();
        newTorrent.setUserId(userId);
        newTorrent.setTorrentName(fileName);
        newTorrent.setFilePath(file.getName());
        newTorrent.setInfoHash(infoHash);
        newTorrent.setFileSize(fileSize);
        newTorrent.setIsRare(false);  // 默认不是冷门
        torrentMapper.insert(newTorrent);

        return newTorrent;
    }

    @Override
    public File handleTorrentDownload(Torrent torrent, String passkey) throws IOException {
        // 原始种子文件读取
        File torrentFile = new File("uploaded-torrents/" + torrent.getFilePath());
        byte[] modifiedBytes = TorrentUtil.injectTracker(torrentFile, tracker + passkey);

        // 写入到临时文件
        File tempFile = File.createTempFile("user_torrent_", ".torrent");
        try (FileOutputStream fos = new FileOutputStream(tempFile)) {
            fos.write(modifiedBytes);
        }

        // 下载统计判断
        if (Boolean.FALSE.equals(torrent.getIsRare())) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (auth != null && auth.getPrincipal() instanceof Long currentUserId) {
                userStatsService.increaseDownloadedBytes(currentUserId, torrent.getFileSize());
            }
        }

        return tempFile;
    }

    @Override
    public Torrent findByInfoHash(String infoHash) {
        return torrentMapper.getTorrentByInfoHash(infoHash);
    }

    @Override
    public Torrent findByTorrentId(Long torrentId) {
        return torrentMapper.getTorrentByTorrentId(torrentId);
    }
}
