package com.example.g8backend.controller;

import com.example.g8backend.dto.ForgotPasswordDTO;
import com.example.g8backend.dto.ResetPasswordDTO;
import com.example.g8backend.service.IForgotPasswordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/forgot-password")
public class ForgotPasswordController {
    @Autowired
    private IForgotPasswordService forgotPasswordService;

    @PostMapping("/send-code")
    public ResponseEntity<?> sendCode(@RequestBody ForgotPasswordDTO dto) {
        forgotPasswordService.sendCodeToEmail(dto.getUsername());
        return ResponseEntity.ok("验证码已发送到注册邮箱");
    }

    @PostMapping("/reset")
    public ResponseEntity<?> resetPassword(@RequestBody ResetPasswordDTO dto) {
        forgotPasswordService.resetPassword(dto.getUsername(), dto.getCode(), dto.getNewPassword());
        return ResponseEntity.ok("密码重置成功");
    }
}