package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.entity.Post;
import com.example.g8backend.entity.PostTag;
import com.example.g8backend.mapper.PostMapper;
import com.example.g8backend.service.IPostService;
import com.example.g8backend.service.IPostTagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.sql.Timestamp;
import java.util.List;

@Service
public class PostServiceImpl extends ServiceImpl<PostMapper, Post> implements IPostService {
    
    private final PostMapper postMapper;

    @Autowired
    private IPostTagService postTagService;

    public PostServiceImpl(PostMapper postMapper) {
        this.postMapper = postMapper;
        this.baseMapper = postMapper; // 重要：设置 baseMapper
    }

    @Override
    public List<Post> getPostsByUserId(Long userId) {
        return postMapper.getPostsByUserId(userId);
    }

    @Override
    public void createPost(Post post) {
        post.setCreatedAt(new Timestamp(System.currentTimeMillis()));
        save(post);
    }

    @Override
    public void createPost(Post post, Long[] tagIds) {
        post.setCreatedAt(new Timestamp(System.currentTimeMillis()));
        save(post);
        for (long tagId : tagIds) {
            postTagService.save(new PostTag(post.getPostId(), tagId));
        }
    }

    @Override 
    public Post updatePost(Post post) {
        updateById(post);
        return getById(post.getPostId());
    }

    @Override
    public List<Post> getPostsByType(String postType) {
        QueryWrapper<Post> wrapper = new QueryWrapper<>();
        wrapper.eq("post_type", postType);
        return list(wrapper);
    }

    @Override
    public Long getPostLikeCount(Long postId) {
        // TODO: 需要实现post_likes表的查询
        return 0L;
    }

    @Override
    public void likePost(Long userId, Long postId) {
        // TODO: 需要实现post_likes表的插入
    }

    @Override
    public void unlikePost(Long userId, Long postId) {
        // TODO: 需要实现post_likes表的删除
    }
}
