import React, { useEffect } from 'react';
import { useApi } from '@/hooks/request';
import request from '@/utils/request';
import { userLogin } from '@/api/user';
import { useAppDispatch } from '@/hooks/store';
import { RootState } from '@/store';
import style from './login.module.css';
import { useSelector } from 'react-redux';
import { useNavigate } from 'react-router';

const Login: React.FC = () => {
    const dispatch = useAppDispatch();
    const { data, loading, error, refresh } = useApi(() => request.post(userLogin), false);

    const nav = useNavigate();
    const handleLogin = async () => {
        const res = await refresh();
        console.log(res);
        dispatch({ type: "user/login", payload: res });
        nav('/');
        
    };
    const userName = useSelector((state: RootState) => state.user.userName);

    return (

        <div className={style.form}>
            <img alt = "logo"></img>
            <input type="email" className={style.email} placeholder="Enter your email" />
            <input type="password" className={style.password} placeholder="Enter your password" />
            <button className={style.submit} onClick={handleLogin}>Login</button>
            <button>Register</button>
        </div>
    );
};

export default Login;