import React, { useEffect } from 'react';
import { useApi } from '@/hooks/request';
import request from '@/utils/request';
import {userLogin} from '@/api/user';
import { useAppDispatch } from '@/hooks/store';

const Login: React.FC = () => {

    const dispatch = useAppDispatch();
    const { data, loading, error, refresh } = useApi(() => request.post(userLogin), false);

    const handleLogin = async () => {
        // 点击时调用 execute 发起请求
        const res = await refresh();
        console.log(res);
        // 请求完成后可以使用返回的数据进行分发
        dispatch({ type: "user/login", payload: res });
    };
    return (
        <div>
            <input type='email'></input>
            <input></input>
            <button onClick={handleLogin}>Login</button>
            <button>Register</button>
        </div>
    );
}

export default Login;