import React from "react";
import { Navigate } from "react-router";
import SelfStatus from "@/components/selfStatus/selfStatus";
import Corner from "@/components/corner/corner";

import style from "./index.module.css";
import Navbar from "@/components/navbar/navbar";
import PostsPanel from "@/components/postsPanel/postsPanel";
import { getHotPosts, getLikePosts} from "@/api/post";
import { Carousel } from 'antd';
import ad1 from '&/assets/ad1.png'
import ad2 from '&/assets/ad2.png'
import { useEffect } from "react";

export default function Forum() {
    useEffect(() => {
        // 禁止滚动
        document.body.style.overflow = 'hidden';

        // 组件卸载时恢复滚动
        return () => {
            document.body.style.overflow = 'auto';
        };
    }, []);
    
    
    return (
        <div className={style.container}>
            <div className={style.up}>
               <div className={style.upleft}>
                <div className={style.navbar}>
                    <Navbar/>
                </div>
                <div className={style.upcontent}>
                    <div className={style.advertisements}>
                        <Carousel arrows infinite={false}>
                            <div>
                                <img src={ad1} alt="广告1" className={style.adImage} />
                            </div>
                            <div>
                                <img src={ad2} alt="广告2" className={style.adImage} />
                            </div>
                        </Carousel>
                    </div>
                    <div className={style.hotPosts}>
                        <PostsPanel name='热门种子' url={getHotPosts} limit={5}/>
                    </div>
                </div>
               </div>
                <div className={style.upright}>
                    <div className={style.selfStatus}>
                        <SelfStatus />
                    </div>
                </div> 
            </div>
            <div className={style.down}>
                <div className={style.newPost}>
                    <PostsPanel name='最新发布' url={getHotPosts} limit={5}/>
                </div>
                <div className={style.likePost}>
                    <PostsPanel name='猜你喜欢' url={getLikePosts} limit={5}/>
                </div>
                <div className={style.forsalePost}>
                    <PostsPanel name='促销种子' url={getHotPosts} limit={5}/>
                </div>
            </div>
        </div>
    );
}