import React, { useCallback, useEffect,useState,useRef } from 'react';
import styles from './homepage.module.css';
import { useApi } from '@/hooks/request';
import { useSelector } from 'react-redux';
import { RootState } from '@/store';
import { useNavigate } from 'react-router';
import  Logo  from '&/assets/logo.png';
import { getUserMessage } from '@/api/homepage'
import { getUserDetail } from '@/api/homepage'
import request from '@/utils/request'
// import { hotPosts } from '@/api/post';
import { postUserLogin } from '@/api/auth';
import { debounce } from 'lodash';
import { Q } from 'react-router/dist/development/fog-of-war-CGNKxM4z';

interface WorkItem {  
  postId: number,
  userId: number,
  postTitle: string,
  postContent: string,
  createdAt: number,
  postType: string,
  isLocked: boolean,
  lockedReason: string,
  lockedAt: string,
  lockedBy: number,
  viewCount: number,
  hotScore: number,
  lastCalculated: number
}

interface UserStats {
  username: string;
  uploadAmount: number;
  level: string;
  likes: number;
  following: number;
  followers: number;
  mutualFollows: number;
}


const Homepage: React.FC =() => {
  const [userStats, setUserStats] = useState<UserStats | null>(null);

  const [works, setWorks] = useState<WorkItem[]>([]);
  const worksRef = useRef<WorkItem[]>([]);


  const navigate = useNavigate();
  const userInfo = useSelector((state: RootState) => state.user);
  const userId = userInfo.userId; // 从Redux获取当前用户ID

  const { data:userdata, loading:userloading, error:usererror, refresh: getUserDetailRefresh } = useApi(
    () => request.get(getUserDetail, {params: {userId}}).then(res => res.data.data),
  );

  const { data:workdata, loading:workloading, error:workerror, refresh: getUserMessageRefresh } = useApi(
    () => request.get(getUserMessage, { params: { userId } }).then(res => res.data.data),
    false
  );

  const getUserDetails = debounce(async () => {
    try{
      const res = await  getUserDetailRefresh({userId});
      console.log("res", res);
      const data = res?.userInfo;

      const formatted: UserStats = {
      username: data.username,
      uploadAmount: data.uploadAmount,
      level: data.level,
      likes: data.likes,
      following: data.following,
      followers: data.followers,
      mutualFollows: data.mutualFollows
      };

      setUserStats(formatted);
    }catch(error){
      console.error('获取用户信息错误', error);
    }
  },1000) as () => void;


  const getUserPost = debounce(async () => {
    try{

      const url = `${getUserMessage}?userId=${userId}`;
      console.log("请求发送:", url);

      const res = await getUserMessageRefresh({userId});
      console.log("res", res);
      worksRef.current = res;
      setWorks(res);
    }catch(error) {
      console.error('获取帖子列表错误', error);
    }
  },1000) as () => void;

  useEffect(() => {
    if (!userId) {
      navigate('/login');
    }
    else {
      getUserDetails();
      getUserPost();
    }
  }, [userId]);

  if (!userId) return null;


  return (
    <div className={styles.container}>


      {/* 用户信息主区域 */}
      <div className={styles.mainContent}>
        {/* 左侧用户信息区 */}
        <div className={styles.userProfile}>
          <div className={styles.userHeader}>
            <img 
              src={userInfo.avatar || '/default-avatar.png'} 
              alt="用户头像" 
              className={styles.userAvatar}
            />
            <div className={styles.userInfo}>
              <h2 className={styles.username}>{userStats?.username}</h2>
              <div className={styles.inviteCode}>邀请码：123456</div>
              <button className={styles.editButton}>编辑主页</button>
            </div>
          </div>

          <div className={styles.userStats}>
            <div className={styles.statItem}>
              <div className={styles.statNumber}>{userStats?.likes ?? '--'}</div>
              <div className={styles.statLabel}>获赞</div>
            </div>
            <div className={styles.statItem}>
              <div className={styles.statNumber}>{userStats?.following ?? '--'}</div>
              <div className={styles.statLabel}>关注</div>
            </div>
            <div className={styles.statItem}>
              <div className={styles.statNumber}>{userStats?.followers ?? '--'}</div>
              <div className={styles.statLabel}>粉丝</div>
            </div>
            <div className={styles.statItem}>
              <div className={styles.statNumber}>{userStats?.mutualFollows ?? '--'}</div>
              <div className={styles.statLabel}>互关</div>
            </div>
          </div>

          <div className={styles.userData}>
            <div className={styles.dataItem}>
              <span>您的总上传量为：</span>
              <strong>{userStats?.uploadAmount ?? '--'}</strong>
            </div>
            <div className={styles.dataItem}>
              <span>您的用户等级为：</span>
              <strong>{userStats?.level ?? '--'}</strong>
            </div>
          </div>

          <div className={styles.worksSection}>
            <h3 className={styles.sectionTitle}>我的作品</h3>
            {workloading && <div className={styles.loading}>加载中...</div>}
            {workerror && <div className={styles.error}>{workerror.message}</div>}
            
            {works.map(work => (
              <div key={work.postId} className={styles.workItem}>
                <h4 className={styles.workTitle}>{work.postTitle}</h4>
                <div className={styles.workMeta}>
                  <span>发布时间：{work.createdAt}</span>
                  <span>下载量：{work.viewCount} 做种数：{'待定'}</span>
                </div>
              </div>
            )) }
          </div>
        </div>

        {/* 右侧内容区 */}
        <div className={styles.rightContent}>
          <div className={styles.petSection}>
            <h3 className={styles.sectionTitle}>宠物图</h3>
            <div className={styles.petContainer}>
              <img 
                src={Logo}
                alt="蓝色星星宠物" 
                className={styles.petImage}
              />
            </div>
          </div>

        </div>
      </div>
    </div>
  );
};

export default Homepage;