// jest.setup.js

// 引入 jest-dom 断言库，使得 expect 可以使用更多 DOM 相关断言
import {jest} from '@jest/globals';
import '@testing-library/jest-dom';
import { TextEncoder, TextDecoder } from 'util';

global.TextEncoder = TextEncoder as typeof global.TextEncoder;
global.TextDecoder = TextDecoder as typeof global.TextDecoder;

// 强制覆盖 window.alert
window.alert = jest.fn(() => {}); // 增加空函数实现

// 保留原始 console.error 的 mock
const originalConsoleError = console.error;
console.error = jest.fn((...args) => {
  originalConsoleError(...args);
});

// 每次测试前重置 mock 状态
beforeEach(() => {
  jest.clearAllMocks();
});

// 如果需要模拟一些全局对象，可以在这里进行
global.localStorage = {
  getItem: jest.fn(),
  setItem: jest.fn(),
  removeItem: jest.fn(),
  clear: jest.fn(),
  key: jest.fn(),
  length: 0,
};

