const { merge } = require('webpack-merge')
const base = require('./webpack.base.js')
const webpack = require('webpack');

module.exports = merge(base, {
  mode: 'development', // 开发模式
  devServer: {
    historyApiFallback: true, 
	  open: true, // 编译完自动打开浏览器
    port: 8081,
  },
  plugins: [
    new webpack.DefinePlugin({
      'process.env': JSON.stringify({
        NODE_ENV: 'development',    // 等价于 mode 设置
        PUBLIC_URL: './',           // 建议使用相对路径
        API_BASE_URL: 'http://localhost:5008', // 添加API路径
        WEB_BASE_URL: 'http://localhost:8080', // 添加WEB路径
      })
    }),
  ],
})