const { merge } = require('webpack-merge')
const base = require('./webpack.base.js')

module.exports = merge(base, {
  mode: 'production', // 生产模式
  plugins: [
    new webpack.DefinePlugin({
      'process.env': JSON.stringify({
        NODE_ENV: 'production',    // 等价于 mode 设置
        PUBLIC_URL: './',           // 建议使用相对路径
        API_BASE_URL: 'http://localhost:5008', // 添加API路径
        WEB_BASE_URL: 'http://localhost:8080', // 添加WEB路径
      })
    }),
  ],
})