
import React, { useState, useCallback, useEffect } from 'react';
import styles from './corner.module.css';
import { useNavigate } from 'react-router';
import { useSearchParams } from 'react-router-dom';
import { MainTag, MainPostTag } from '@/types/common';
import { Button, Checkbox, Row, Col } from 'antd';
import { getTagsByMainTag } from '@/utils/common';
interface CornerProp  {

  setTagIds: (tagIds: number[]) => void;
}

const BottomRightUpload: React.FC<CornerProp> = (props:CornerProp) => {
  const [searchParams] = useSearchParams();
  const [tags, setTags] = useState<Map<string, number>>(new Map);
  const [selectdTags, setSelectedTags] = useState<number[]>([])
  const setTagIds = props.setTagIds;
  const navigate = useNavigate();
  const type = searchParams.get('type');

  const handleUploadClick = () => {
    navigate('/createPost', { state: { isNewPost: true, type} });
  };
  useEffect(()=>{
    setTags(getTagsByMainTag(type as string))
  },[])

  return (
    <div className={styles.container}>
      <button className={styles.uploadButton} onClick={handleUploadClick}>
        发布种子
      </button>

      <div className={styles.filterItem}>
        <label htmlFor="rating">评分：</label>
        <select id="rating">
          <option value="all">全部</option>
          <option value="high">高评分</option>
          <option value="medium">中评分</option>
          <option value="low">低评分</option>
        </select>
      </div>

      <div className={styles.filterItem}>
        <label htmlFor="tag">标签：</label>
        <Checkbox.Group
          value={selectdTags}
          onChange={(checkedValues) =>{
              setSelectedTags([...checkedValues])
          }}
        >
          <Row gutter={[12, 12]}>
            {[...tags.entries()].map(([name, id]) => (
              <Col key={id} xs={12} sm={12} md={8} lg={6}>
                <Checkbox value={id}>{name}</Checkbox>
              </Col>
            ))}
          </Row>
        </Checkbox.Group>
      </div>

      <Button
        color='primary'
        variant='outlined'
        onClick={()=>{
          console.log(selectdTags)
          setTagIds([...selectdTags])

        }}
      > 筛选 </Button>

      <Button
        color='danger'
        variant='outlined'
        onClick={()=>{
          setTagIds([])
          setSelectedTags([])
        }}
      >清空筛选
      </Button>
    </div>
  );
};

export default BottomRightUpload;
