import React, { use, useEffect } from "react";
import Icon, {
    HomeOutlined,
} from "@ant-design/icons";
import { Space } from 'antd';
import type { GetProps } from 'antd';
import type { MenuProps } from 'antd';
import { Menu } from 'antd';
import { useState } from "react";
import style from './navbar.module.css'
import { set } from "lodash";
import { useNavigate } from "react-router";

type CustomIconComponentProps = GetProps<typeof Icon>;
type MenuItem = Required<MenuProps>['items'][number];
const web_base_url = process.env.WEB_BASE_URL || 'http://localhost:3000';
const VideoSvg = () => (
    <svg width="1em" height="1em" fill="currentColor" xmlns="http://www.w3.org/2000/svg" p-id="7331" viewBox="0 0 1024 1024">
      <title>video icon</title>
      <path d="M85.333333 348.091733V764.586667a153.6 153.6 0 0 0 153.6 153.6h561.578667a153.6 153.6 0 0 0 153.6-153.6V348.091733a153.6 153.6 0 0 0-153.6-153.6H238.933333a153.6 153.6 0 0 0-153.6 153.6z m68.266667 0a85.333333 85.333333 0 0 1 85.333333-85.333333h561.578667a85.333333 85.333333 0 0 1 85.333333 85.333333V764.586667a85.333333 85.333333 0 0 1-85.333333 85.333333H238.933333a85.333333 85.333333 0 0 1-85.333333-85.333333V348.091733z" fill="#000000" p-id="7332"></path><path d="M401.885867 182.254933l-65.467734-69.188266a34.133333 34.133333 0 1 0-49.578666 46.933333l65.450666 69.1712a34.133333 34.133333 0 0 0 49.595734-46.916267zM635.989333 182.254933l65.467734-69.188266a34.133333 34.133333 0 1 1 49.578666 46.933333l-65.467733 69.1712a34.133333 34.133333 0 0 1-49.578667-46.916267zM383.556267 472.405333v167.168a85.333333 85.333333 0 0 0 128.733866 73.454934l141.482667-83.575467a85.333333 85.333333 0 0 0 0-146.944l-141.482667-83.575467a85.333333 85.333333 0 0 0-128.733866 73.454934z m68.266666 0a17.066667 17.066667 0 0 1 25.7536-14.711466l141.4656 83.592533a17.066667 17.066667 0 0 1 0 29.3888l-141.482666 83.575467a17.066667 17.066667 0 0 1-25.736534-14.677334v-167.185066z" fill="#000000" p-id="7333"></path>
    </svg>
);
const MusicSvg = () => (
    <svg width="1em" height="1em" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="2776" viewBox="0 0 1024 1024">
        <title>music icon</title>
        <path d="M895.456 770.56C895.552 769.696 896 768.896 896 768L896 160c0-1.056-0.512-1.984-0.608-3.008-0.032-1.664 0.448-3.232 0.16-4.928-2.88-17.408-19.328-29.184-36.8-26.304l-480 80c-17.408 2.912-29.216 19.392-26.304 36.832 0.256 1.472 1.024 2.656 1.44 4.032C352.96 249.664 352 252.672 352 256l0 429.6c-20.128-9.376-43.648-14.784-69.408-14.784-21.312 0-42.816 3.456-63.968 10.336-39.616 12.8-73.536 36.224-95.584 65.984-24.064 32.512-31.68 70.24-20.864 103.648 15.648 48.288 66.656 79.456 129.92 79.456 21.248 0 42.72-3.456 63.904-10.304 58.656-19.04 100.288-59.2 115.04-103.808C413.888 811.328 416 806.016 416 800l0-5.312c1.056-8.48 1.056-16.96 0-25.472L416 264.448l416-69.344 0 490.88c-20.32-9.632-44.096-15.2-70.176-15.2-21.28 0-42.816 3.456-63.968 10.336-39.584 12.8-73.568 36.224-95.584 65.984-24.096 32.512-31.68 70.24-20.864 103.648 15.648 48.288 66.656 79.456 129.92 79.456 21.248 0 42.752-3.456 63.904-10.304C853.472 894.56 902.176 831.68 895.456 770.56z" fill="#5D646F" p-id="2777"></path>
      
    </svg>
);
const GameSvg = () => (
    <svg width="1em" height="1em" fill="currentColor" xmlns="http://www.w3.org/2000/svg" p-id="8400" viewBox="0 0 1024 1024">
        <title>game icon</title>
        <path d="M683.2 588.8m-43.2 0a43.2 43.2 0 1 0 86.4 0 43.2 43.2 0 1 0-86.4 0Z" p-id="8401"></path><path d="M942.4 358.4c-30.4-17.6-64-25.6-97.6-25.6H555.2v-256c0-25.6-17.6-43.2-43.2-43.2s-43.2 17.6-43.2 43.2v256H174.4C81.6 332.8 0 414.4 0 512v299.2c0 97.6 81.6 179.2 174.4 179.2 84.8 0 158.4-64 174.4-145.6h324.8c17.6 81.6 84.8 145.6 174.4 145.6 97.6 0 174.4-81.6 174.4-179.2V512c1.6-59.2-28.8-120-80-153.6z m-4.8 456c0 51.2-36.8 94.4-88 94.4s-89.6-43.2-89.6-94.4c0-30.4-20.8-56-56-56H353.6c-64 0-84.8 25.6-84.8 56 0 51.2-43.2 89.6-89.6 89.6-51.2 0-89.6-43.2-89.6-94.4V507.2c-4.8-46.4 38.4-89.6 84.8-89.6H848c25.6 0 46.4 8 64 30.4 17.6 17.6 25.6 38.4 25.6 64v302.4z" p-id="8402"></path><path d="M340.8 545.6h-43.2v-43.2c0-25.6-17.6-43.2-43.2-43.2s-43.2 17.6-43.2 43.2v43.2h-43.2c-25.6 0-43.2 17.6-43.2 43.2s17.6 43.2 43.2 43.2h43.2v43.2c0 25.6 17.6 43.2 43.2 43.2s43.2-17.6 43.2-43.2v-43.2h43.2c25.6 0 43.2-17.6 43.2-43.2s-17.6-43.2-43.2-43.2z" p-id="8403"></path><path d="M852.8 588.8m-43.2 0a43.2 43.2 0 1 0 86.4 0 43.2 43.2 0 1 0-86.4 0Z" p-id="8404"></path><path d="M768 504m-43.2 0a43.2 43.2 0 1 0 86.4 0 43.2 43.2 0 1 0-86.4 0Z" p-id="8405"></path><path d="M768 673.6m-43.2 0a43.2 43.2 0 1 0 86.4 0 43.2 43.2 0 1 0-86.4 0Z" p-id="8406"></path>
    </svg>
);
const SoftwareSvg = () => (
    <svg width="1em" height="1em" fill="currentColor" xmlns="http://www.w3.org/2000/svg" p-id="10283" viewBox="0 0 1024 1024">
        <title>software icon</title>
        <path d="M398.208 113.792v284.448H113.76V113.792h284.448z m0-56.896H113.76c-31.296 0-56.896 25.6-56.896 56.896v284.448c0 31.296 25.6 56.896 56.896 56.896h284.448c31.296 0 56.896-25.6 56.896-56.896V113.792c0-31.296-25.6-56.896-56.896-56.896z m0 568.896v284.448H113.76v-284.448h284.448z m0-56.896H113.76c-31.296 0-56.896 25.6-56.896 56.896v284.448c0 31.296 25.6 56.896 56.896 56.896h284.448c31.296 0 56.896-25.6 56.896-56.896v-284.448c0-31.296-25.6-56.896-56.896-56.896z m512-455.104v284.448h-284.448V113.792h284.448z m0-56.896h-284.448c-31.296 0-56.896 25.6-56.896 56.896v284.448c0 31.296 25.6 56.896 56.896 56.896h284.448c31.296 0 56.896-25.6 56.896-56.896V113.792c0-31.296-25.6-56.896-56.896-56.896z m0 568.896v284.448h-284.448v-284.448h284.448z m0-56.896h-284.448c-31.296 0-56.896 25.6-56.896 56.896v284.448c0 31.296 25.6 56.896 56.896 56.896h284.448c31.296 0 56.896-25.6 56.896-56.896v-284.448c0-31.296-25.6-56.896-56.896-56.896z" p-id="10284"></path>
    </svg>
);
const ChatSvg = () => (
    <svg width="1em" height="1em" fill="currentColor" xmlns="http://www.w3.org/2000/svg" p-id="15809" viewBox="0 0 1024 1024">
        <title>chat icon</title>
        <path d="M920.642991 1.684336h-583.775701c-48.08972 0-87.327103 39.428785-87.327103 87.738617v88.217122H103.596262c-48.328972 0-87.566355 39.419215-87.566355 87.977869V675.935701c0 48.558654 39.237383 87.977869 87.566355 87.977869H133.024299v229.31858a28.901682 28.901682 0 0 0 18.42243 27.159925c3.588785 1.435514 7.17757 2.162841 10.766355 2.162841a29.284486 29.284486 0 0 0 21.293458-9.129869L418.691589 763.674318h268.201869c23.685981 0 44.740187-10.335701 60.770093-26.202916l93.069159 98.552822c5.742056 6.010019 13.398131 9.139439 21.293458 9.13944 3.588785 0 7.17757-0.727327 10.766355-2.162842a29.265346 29.265346 0 0 0 18.42243-27.169495V587.718579H920.642991c48.08972 0 87.327103-39.428785 87.327102-87.738616v-410.55701C1007.730841 41.103551 968.73271 1.684336 920.642991 1.684336zM686.893458 705.019215h-281.839252c-9.809346 0-18.183178 5.292262-23.446729 12.737794L191.401869 919.437159V735.547813c0-0.239252-0.239252-0.478505-0.239252-0.717757 0-0.239252 0.239252-0.478505 0.239252-0.727327 0-16.096897-13.158879-29.322766-29.188785-29.322766H103.596262c-16.029907 0-29.188785-13.216299-29.188785-29.322767V265.617944c0-16.106467 13.158879-29.332336 29.188785-29.332337h145.943925v263.943178c0 48.309832 39.237383 87.729047 87.327103 87.729047h269.876635l101.442991 107.453009c-5.502804 5.761196-12.919626 9.608374-21.293458 9.608374z m262.699065-204.8c0 16.106467-12.919626 29.093084-28.949532 29.093084h-58.616823c-16.029907 0-29.188785 13.206729-29.188785 29.322766v183.889346l-192.358878-204.082243-0.239253-0.239252c-1.914019-1.923589-4.06729-3.129421-6.459813-4.564935-0.957009-0.727327-1.914019-1.684336-3.11028-1.923588-0.957009-0.478505-1.914019-0.239252-2.871028-0.727328a24.757832 24.757832 0 0 0-8.373832-1.684336H336.86729a28.968673 28.968673 0 0 1-28.949533-29.083514V89.422953c0-16.106467 12.919626-29.093084 28.949533-29.093084h583.775701a28.968673 28.968673 0 0 1 28.949532 29.093084v410.796262z" fill="#2E323F" p-id="15810"></path>
    </svg>
);


const MusicIcon = (props: Partial<CustomIconComponentProps>) => (
    <Icon component={MusicSvg} {...props} />
);
const VideoIcon = (props: Partial<CustomIconComponentProps>) => (
    <Icon component={VideoSvg} {...props} />
);
const GameIcon = (props: Partial<CustomIconComponentProps>) => (
    <Icon component={GameSvg} {...props} />
);
const SoftwareIcon = (props: Partial<CustomIconComponentProps>) => (
    <Icon component={SoftwareSvg} {...props} />
);
const ChatIcon = (props: Partial<CustomIconComponentProps>) => (
    <Icon component={ChatSvg} {...props} />
);

const items: MenuItem[] = [
{
    key: 'home',
    icon: <HomeOutlined />,
    label: (
    <a href={'/'}>
        首页
    </a>
    ),
},
{
    key: 'video',
    icon: <VideoIcon />,
    label: (
    <a href={'/posts?type=video'}>
        影视
    </a>
    ),
},
{
    key: 'music',
    icon: <MusicIcon />,
    label: (
    <a href={'/posts?type=music'}>
        音乐
    </a>
    ),
},
{
    key: 'game',
    icon: <GameIcon />,
    label: (
    <a href={'/posts?type=Game'}>
        游戏
    </a>
    ),
},
{
    key: 'software',
    icon: <SoftwareIcon />,
    label: (
    <a href={'/posts?type=software'}>
        软件
    </a>
    ),
},
{
    key: 'chat',
    icon: <ChatIcon />,
    label: (
    <a href={'/posts?type=chat'}>
        聊天
    </a>
    ),
},
];

interface NavbarProps {
    current?: string;
}



const Navbar: React.FC<NavbarProps> = (props) => {
    const [current, setCurrent] = useState('home');
    useEffect(() => {
        console.log('current:', props.current);
        if (props.current) {
            setCurrent(props.current);
        }
    },[props.current]);
    const onClick: MenuProps['onClick'] = (e) => {
        console.log('click ', e);
        setCurrent(e.key);
    };

    return <Menu className={style.menu} onClick={onClick} selectedKeys={[current]} mode="horizontal" items={items} />;
}

export default Navbar;
