import { useApi } from '@/hooks/request';
import React, { useCallback, useEffect, useState } from  'react';
import request from '@/utils/request'
import style from './postsPanel.module.css'
import { useNavigate } from 'react-router';


interface panelProps{
    name:string,
    url:string,
    limit:number
}

const PostsPanel:React.FC<panelProps> = (props) => {
    const nav = useNavigate();
    const fenchData = useCallback(() => request.get(`${props.url}?page=1&size=5`), [props.url])
    const {data} = useApi(fenchData, true);
    const handlePostCheck =(postId:string) =>{
        nav('/postDetail?postId=' + postId);
    }

    useEffect(()=>{
        if(data){
            console.log("data!!!")
            console.log(data)
        }
    }, [data])

    return (
        <div className={style.panel}>
            <div className={style.header}>
                <span className={style.title}>{props.name}</span>
                <span className={style.more}>更多</span>
            </div>
            <div className={style.content} >
                {data && data.records && data.records.length > 0 ?
                data.records.map((item: {postId:string, postTitle: string; createdAt: string }, index: number) => (
                    <div key={index} className={style.item} onClick={()=> handlePostCheck(item.postId)} >
                        <span className={style.text}>{item.postTitle}</span>
                        <span>{new Date(item.createdAt).toLocaleString()}</span>
                    </div>
                ))  :(
                    <div>未查询到相关记录</div>
                )}
            </div>
        </div>
    )
}

export default PostsPanel;