import React, { useEffect, useRef } from "react";
import { useAppSelector } from "../../hooks/store";
import style from "./style.module.css"
import { useApi } from "@/hooks/request";
import request from "@/utils/request";
import { getUserInfo } from "@/api/user";
import { useAppDispatch } from "@/hooks/store";
import type { MenuProps } from 'antd';
import { useNavigate } from "react-router";
import { Dropdown } from "antd";


interface SelfStatusProps {
    className?: string;
}

const SelfStatus: React.FC<SelfStatusProps> = () => {

    const nav = useNavigate()
    const userName = useAppSelector(state => state.user.userName);
    const role = useAppSelector(state => state.user.role);
    const uploadTraffic = useAppSelector(state => state.user.uploadTraffic);
    const downloadTraffic = useAppSelector(state => state.user.downloadTraffic);
    const downloadPoints = useAppSelector(state => state.user.downloadPoints);
    const avatar = useAppSelector(state => state.user.avatar)  || 'https://pic.baike.soso.com/ugc/baikepic2/6664/20220301143956-1127285627_png_800_800_370852.jpg/0';
    const dispatch = useAppDispatch();
    const { refresh } = useApi(() => request.get(getUserInfo), false);
    const fenchData = async () => {
        const data = await refresh();
        console.log(data)

        if (data) {
            dispatch({ type: "user/getUserInfo", payload: data.userInfo });
        }
    }

    const logOut = () =>{
        dispatch({type:"user/logout"})
        nav('/')
    }

    const menu: MenuProps['items'] =[
    {
        key:'1',
        label:(<span onClick={logOut}>登出</span>)
    }
]
    useEffect(() => {
        fenchData();
        
    }, [ dispatch]);

    return (
        <div className={style.container}>
            <div className={style.left}
                
            >
                {avatar && avatar.length > 0 ? (
                <img className={style.avatar} onClick={() => nav('/homepage')} style={{ cursor: 'pointer'}}  src={avatar} alt="User Avatar" />):null}
            </div>
            <div className={style.right}>
                <div className={style.info}>
                    <Dropdown menu={{ items: menu }}>
                        <p className={style.userName}>{userName}</p>
                    </Dropdown>
                    <p className={style.role}>用户组: {role && role.trim().length? role:'N/A'}</p>
                    <p className={style.uploadTraffic}>上传量: {uploadTraffic ? uploadTraffic : 0}</p>
                    <p className={style.downloadTraffic}>下载量: {downloadTraffic ? downloadTraffic : 0}</p>

                    <p className={style.shareRatio}>
                        分享率: {uploadTraffic && downloadTraffic ? (uploadTraffic / downloadTraffic).toFixed(2) : "N/A"}
                    </p>
                    <p className={style.downloadPoints}>下载积分: {downloadPoints ? downloadPoints : 0}</p>
                </div>
                <button className={style.signInButton}>签到</button>
            </div>
        </div>
    );
};

export default SelfStatus;
