import React, { use } from "react";
import {createRoot} from "react-dom/client"
import { Provider } from "react-redux";
import router from "./route";
import store from "./store/index";
import { RouterProvider } from "react-router";
import './global.css';

if(localStorage.getItem("theme") === null) {
    localStorage.setItem("theme", "light");
    document.body.className="light";
}else{
    document.body.className=localStorage.getItem("theme")!;
}

const root = createRoot(document.getElementById('root')!)

root.render(
    <Provider store={store}>
        <RouterProvider router={router}/>
    </Provider>
)
