import Mock from 'mockjs';
import MockAdapter from 'axios-mock-adapter';
import {postUserLogin, getRefreshToken} from '@/api/auth'; // Import the API endpoint



function generateToken(userId, role) {
  const exp = Math.floor(Date.now() / 1000) + 60 * 60;

  // 生成 JWT Header
  const header = {
      alg: 'HS256', // 签名算法
      typ: 'JWT',   // 类型
  };

  // 生成 JWT Payload
  const payload = {
      userId,
      role,
      exp,
  };

  // Base64 编码 Header 和 Payload
  const base64Header = btoa(JSON.stringify(header));
  const base64Payload = btoa(JSON.stringify(payload));

  // 模拟 Signature（实际应使用密钥进行 HMAC-SHA256 签名）
  const signature = btoa('mock-signature'); // 简单模拟签名

  // 拼接 JWT Token
  const token = `${base64Header}.${base64Payload}.${signature}`;
  return token;
}
/**
 * 设置用户相关的 Mock 接口
 * @param {MockAdapter} mock 
 */
export function setupAuthMock(mock) {
  mock.onPost(postUserLogin).reply(config => {
    const data = JSON.parse(config.data);
    if(data.email === 'admin@1' && data.password === '123456'){
      // 模拟用户登录数据
      const token = generateToken(1, 'admin'); 
      
      // 返回模拟的 Token
      let data = Mock.mock({
          token,
      });
      return [200, data];
    }else{
      return [401, {message: '用户名或密码错误'}];
    }
  });
  mock.onGet(getRefreshToken).reply(config => {
      // 模拟用户登录数据
      const  token = generateToken(1, 'admin'); // 这里的 1 和 'admin' 可以根据需要修改
      // 返回模拟的 Token
      let data = Mock.mock({
          token,
      });
      return [200, data];
  })
}
