import mockjs from "mockjs";
import MockAdapter from "axios-mock-adapter";
import { getPostComments} from "@/api/comment";

export function setupCommentMock(mock) {
    const getPostCommentsPattern = new RegExp(`^${getPostComments}/\\d+$`);
    mock.onGet(getPostCommentsPattern).reply(config => {
         let data = mockjs.mock({
            [`list|5`]: [
                {
                    "commentId|+1": 1, // 自增评论 ID
                    "content": "@cparagraph(1, 3)", // 随机生成 1-3 段评论内容
                    "createdAt": "@datetime('T')", // 随机生成时间戳
                    "parentCommentId": null, // 顶级评论的父评论 ID 为 null
                    "postId|1-100": 1, // 随机生成帖子 ID
                    "userId|1-100": 1, // 随机生成用户 ID
                    "replies|0-3": [ // 随机生成 0-3 条子评论
                        {
                            "commentId|+1": 100, // 子评论的 ID 从 100 开始自增
                            "content": "@cparagraph(1, 2)", // 随机生成 1-2 段子评论内容
                            "createdAt": "@datetime('T')", // 随机生成时间戳
                            "parentCommentId": "@increment(1)", // 父评论 ID
                            "postId|1-100": 1, // 随机生成帖子 ID
                            "userId|1-100": 1, // 随机生成用户 ID
                            "replies": [] // 子评论的子评论为空
                        }
                    ]
                },
            ],
        });
        return [200, data.list];
    });

}