import Mock from 'mockjs';
import MockAdapter from 'axios-mock-adapter';
import {getUserMessage} from '@/api/homepage';

/**
 * 设置用户相关的 Mock 接口
 * @param {MockAdapter} mock 
 */
export function setupUserMessageMock(mock) {
    mock.onGet(getUserMessage).reply((config) => {
        console.log("visited")
        let data = Mock.mock({
            'username': '阳菜，放睛！',
            'inviteCode': '1314520',
            'stats': {
                'likes': 0,
                'following': 25,
                'followers': 276,
                'mutualFollows': 52
            },
            'upload': '5.2 ',
            'level': '荣耀会员',
            // 'works': [{
            //     'id': 1,
            //     'title': '【PC】【ARPG】【开放世界】刺客信条影破解版',
            //     'publishTime': '2025-3-21',
            //     'downloadCount': 0,
            //     'seedCount': 1
            // }],
            'works': [{
                'postId': 0,
                'userId': 0,
                'postTitle': '阳菜',
                "postContent": "",
                "createdAt": 0,
                "postType": "",
                "viewCount": 0,
                "hotScore": 0.0,
                "lastCalculated": 0
                }],
            'petImage': '/assets/pet-blue-star.png',
            'trafficImage': '/assets/duck-computer.png'
        });
        return [200, data];
    });
}