import MockAdapter from 'axios-mock-adapter';
import instance from '@/utils/axios'
import { setupAuthMock }  from './auth'
import { setupUserMock } from './user';
import { setupPostMock } from './post';
import { setupCommentMock } from './comment';
import {setupUserMessageMock} from './homepage';
import { setupUploadMock } from './upload';


// 聚合所有 Mock 模块
export function setupMock() {
  return;
  const mock = new MockAdapter(instance, { 
    delayResponse: process.env.NODE_ENV === 'test' ? 0 : 500 
  })
  // 开发环境启用 Mock
  if (process.env.NODE_ENV !== 'development') return

  // 加载各模块 Mock
  setupAuthMock(mock)
  setupUserMock(mock)
  setupPostMock(mock)
  setupCommentMock(mock)
  setupUserMessageMock(mock)
  setupUploadMock(mock)
  console.log('Mock 模块已加载')
}

