import Mock from 'mockjs';
import MockAdapter from 'axios-mock-adapter';
import {getHotPosts, getLikePosts, getPosts, getPostDetail} from '@/api/post'

/**
 * 设置用户相关的 Mock 接口
 * @param {MockAdapter} mock 
 */
export function setupPostMock(mock){
    const hotPostsPattern = new RegExp(`^${getHotPosts}(\\?page=\\d+&size=\\d+)?$`);
    const LikePostsPattern = new RegExp(`^${getLikePosts}(\\?page=\\d+&size=\\d+)?$`);
    const searchPostsPattern = new RegExp(`^${getPosts}\\?((keyword=[^&]+&?)|(tags=[^&]+&?)|(author=[^&]+&?)|)+(page=\\d+)&(pageSize=\\d+)$`);
    mock.onGet(hotPostsPattern).reply(config => {
      const urlParams = new URLSearchParams(config.url.split('?')[1]);
      const size = parseInt(urlParams.get('size')) || 10;
      let data = Mock.mock({
        [`list|${size}`]: [
          {
            'postId|+1': 1,
            'postTitle': '@ctitle(5, 10)',
            'postContent': '@cparagraph(1, 3)',
            'author': '@cname()',
            'createdAt': '@date("yyyy-MM-dd")',
            'viewCount|1-100': 1,
          },
        ],
      });
      return [200, data.list];
    });
      mock.onGet(LikePostsPattern).reply(config => {
        const urlParams = new URLSearchParams(config.url.split('?')[1]);
        const size = parseInt(urlParams.get('size')) || 10;
        let data = Mock.mock({
          [`list|${size}`]: [
            {
              'postId|+1': 1,
              'postTitle': '@ctitle(5, 10)',
              'postContent': '@cparagraph(1, 3)',
              'author': '@cname()',
              'createdAt': '@date("yyyy-MM-dd")',
              'viewCount|1-100': 1,
            },
          ],
        });
        return [200, data.list];
      });
      mock.onGet(searchPostsPattern).reply(config => {
        const urlParams = new URLSearchParams(config.url.split('?')[1]);
        const tags = urlParams.get('tags')?.split(',') || []; // 将 tags 参数解析为数组
        const page = parseInt(urlParams.get('page')) || 1; // 默认 page 为 1
        const size = parseInt(urlParams.get('size')) || 10; // 默认 size 为 10
        let data = Mock.mock({
          [`list|${size}`]: [
            {
              'postId|+1': 1,
              'postTitle': '@ctitle(5, 10)',
              'postContent': '@cparagraph(1, 3)',
              'author': '@cname()',
              'createdAt': '@date("yyyy-MM-dd")',
              'viewCount|1-100': 1,
            },
          ],
        });
        return [200, data.list];
      });


      const getPostDetailPattern = new RegExp(`^${getPostDetail}/[0-9]+$`);
      mock.onGet(getPostDetailPattern).reply(config => {
        const postId = config.url.split('/').pop();
        let data = Mock.mock({
          'postId': postId,
          'postTitle': '@ctitle(5, 10)',
          'postContent': '@cparagraph(1, 3)',
          'author': '@cname()',
          'createdAt': '@date("yyyy-MM-dd")',
          'viewCount|1-100': 1,
        });
        return [200, data];
      });


}    
