import Mock from 'mockjs';
import MockAdapter from 'axios-mock-adapter';
import {getUserInfo} from '@/api/user'// Import the API endpoint

/**
 * 设置用户相关的 Mock 接口
 * @param {MockAdapter} mock 
 */
export function setupUserMock(mock){
    mock.onGet(getUserInfo).reply(config => {
        let data = Mock.mock({
            'userId' : '001',
            'userName' : 'san3yuan',
            'role' : 'manager',
            'uploadTraffic' : 0,
            'downloadTraffic': 0,
            'downloadPoints' : 0,
            'avatar' : 'https://www.w3school.com.cn/i/photo/tulip.jpg',
        });
        return [200, data];
      });
}    
