import { createBrowserRouter } from 'react-router-dom'
import PrivateRoute from './privateRoute'
import { useSelector } from 'react-redux'
import Login from '../views/login/login'
import Homepage from '../views/homepage/homepage'
import Upload from '../views/upload/upload'
import Search from '../views/search/search'
import Frame from '../views/frame/frame'
import React from 'react'
import Forum from '../views/forum'
import { RootState } from '@/store'
import PostList from '../views/postList/postList'
import PostDetail from '../views/postDetail/postDetail'

const router = createBrowserRouter([
    {
        path: '/',
        element:
        <PrivateRoute
        role={0} // 判断是否登录
        redirectPath="/login"/>, 
        children: [
            {
                path:'/',
                element: <Frame/>,
                children: [
                    {
                        index: true,
                        element:<Forum/>

                    },
                    {
                        path: '/posts',
                        element: <PostList/>
                    },
                    {
                        path: '/postsDetail',
                        element: <PostDetail/>
                    },
                    {
                        path:'/homepage',
                        element: <Homepage/>
                    },
                    {
                        path:'/createPost',
                        element: <Upload/>
                    },
                    {
                        path:'/search',
                        element:<Search/>
                    }
                ]
            },
        ]
    },
    {
        path: '/login',
        element: <Login /> // 登录页作为独立路由
    }


    
]
)

export default router