import { createSlice } from '@reduxjs/toolkit';
import { isTokenExpired } from '@/utils/jwt';
import { getUserInfo } from '@/api/user';

interface UserState {
    userId: string;
    userName: string;
    role: string;
    isLogin: boolean;
    uploadTraffic: number;
    downloadTraffic: number;
    downloadPoints: number;
    avatar: string;
}

const initialState: UserState = {
    userId: '',
    userName: '',
    role: '',
    isLogin: localStorage.getItem('token')&& isTokenExpired(localStorage.getItem('token') as string) ==='0'  ? true : false,
    uploadTraffic: 0,
    downloadTraffic: 0,
    downloadPoints: 0,
    avatar: '',
};


export const userSlice = createSlice({
    name: 'user',
    initialState,
    reducers: {
        login: (state, action) => {
            console.log(action.payload)
            localStorage.setItem('token', action.payload.token);
            state.isLogin = true;
        },
        getUserInfo: (state, action) => {
            console.log(action);
            state.userId = action.payload.userId;
            state.userName = action.payload.userName;
            state.role = action.payload.role;
            state.uploadTraffic = action.payload.uploadTraffic;
            state.downloadTraffic = action.payload.downloadTraffic;
            state.downloadPoints = action.payload.downloadPoints;
            state.avatar = action.payload.avatar;
        },
        logout: (state) => {
            state.userId = '';
            state.userName = '';
            state.role = '';
            state.isLogin = false;
            state.uploadTraffic = 0;
            state.downloadTraffic = 0;
            state.downloadPoints = 0;
            state.avatar = '';
        },
        updateTraffic: (state, action) => {
            state.uploadTraffic = action.payload.uploadTraffic;
            state.downloadTraffic = action.payload.downloadTraffic;
            state.downloadPoints = action.payload.downloadPoints;
        },
        updateAvatar: (state, action) => {
            state.avatar = action.payload.avatar;
        }
    },

});

export const { login, logout, updateTraffic } = userSlice.actions;
export default userSlice.reducer;