export enum MainPostTag {
    Game = 0,
    android = 1,
    mac = 2,
    pc = 3,
    ios = 4,
    other = 5,
    action = 6,
    adventure = 7,
    leisure = 8,
    riddle = 9,
    sport = 10,
    strategy = 11,
    table = 12,

    video = 20,
    chinese_video = 21,
    America_video = 22,
    Japan_video = 23,
    Korea_video = 24,
    Europe_video = 25,
    other_video = 26,
    Short = 27,
    plot = 28,
    comedy = 29,
    love = 30,
    action_video = 31,
    terror = 32,
    science_fiction = 33,
    commit_a_crime = 34,
    Thriller = 35,

    music = 40,
    chinese_music = 41,
    America_music = 42,
    Japan_music = 43,
    Korea_music = 44,
    Europe_music = 45,
    other_music = 46,
    rap = 47,
    Electric_sound = 48,
    Guofeng = 49,
    motion = 50,
    ballad = 51,
    Rock_and_roll = 52,
    classical = 53,

    software = 60,
    android_software = 61,
    mac_software = 62,
    pc_software = 63,
    ios_software = 64,
    other_software = 65,
    life = 66,
    shopping = 67,
    video_software = 68,
    music_software = 69,
    read = 70,
    system = 71,
}

// 可选：标签的父子关系映射
export const MainPostTagParent: Record<number, number | null> = {
    0: null,
    1: 0,
    2: 0,
    3: 0,
    4: 0,
    5: 0,
    6: 0,
    7: 0,
    8: 0,
    9: 0,
    10: 0,
    11: 0,
    12: 0,

    20: null,
    21: 20,
    22: 20,
    23: 20,
    24: 20,
    25: 20,
    26: 20,
    27: 20,
    28: 20,
    29: 20,
    30: 20,
    31: 20,
    32: 20,
    33: 20,
    34: 20,
    35: 20,

    40: null,
    41: 40,
    42: 40,
    43: 40,
    44: 40,
    45: 40,
    46: 40,
    47: 40,
    48: 40,
    49: 40,
    50: 40,
    51: 40,
    52: 40,
    53: 40,

    60: null,
    61: 60,
    62: 60,
    63: 60,
    64: 60,
    65: 60,
    66: 60,
    67: 60,
    68: 60,
    69: 60,
    70: 60,
    71: 60,
};

// 可选：数字到标签名的映射
export const MainPostTagName: Record<number, string> = {
    0: 'Game',
    1: 'android',
    2: 'mac',
    3: 'pc',
    4: 'ios',
    5: 'other',
    6: 'action',
    7: 'adventure',
    8: 'leisure',
    9: 'riddle',
    10: 'sport',
    11: 'strategy',
    12: 'table',

    20: 'video',
    21: 'chinese',
    22: 'America',
    23: 'Japan',
    24: 'Korea',
    25: 'Europe',
    26: 'other',
    27: 'Short',
    28: 'plot',
    29: 'comedy',
    30: 'love',
    31: 'action',
    32: 'terror',
    33: 'science fiction',
    34: 'commit a crime',
    35: 'Thriller',

    40: 'music',
    41: 'chinese',
    42: 'America',
    43: 'Japan',
    44: 'Korea',
    45: 'Europe',
    46: 'other',
    47: 'rap',
    48: 'Electric sound',
    49: 'Guofeng',
    50: 'motion',
    51: 'ballad',
    52: 'Rock and roll',
    53: 'classical',

    60: 'software',
    61: 'android',
    62: 'mac',
    63: 'pc',
    64: 'ios',
    65: 'other',
    66: 'life',
    67: 'shopping',
    68: 'video',
    69: 'music',
    70: 'read',
    71: 'system',
};

export const MainTag = [
    'video',
    'Game',
    'music',
    'software'
]