import axios from 'axios'
import type { AxiosRequestConfig, AxiosResponse } from 'axios'

const instance = axios.create({
    baseURL: process.env.API_BASE_URL,
    timeout: 10000,
    headers: {
      'Content-Type': 'application/json'
    }
  })
  
  // 请求拦截器
  instance.interceptors.request.use(
    (config) => {
      console.log('Request Config:', config)
      // 添加认证 token
      const token = localStorage.getItem('token')
      if (token) {
        config.headers.Authorization = `Bearer ${token}`
      }
      return config
    },
    (error) => {
      return Promise.reject(error)
    }
  )
  
  // 响应拦截器
  instance.interceptors.response.use(
    (response) => {
      if(response.headers['content-type']!=='application/x-bittorrent')
      {
        if (response.status === 200) {
          return response.data.data
        }
        return Promise.reject(response.data)
      }else {
        return response
      }
    },
    (error) => {
      if(error.status===401){
        localStorage.removeItem('token');
        // window.location.href = '/login';
      }
      // 统一错误处理
      console.error('API Error:', error.response?.status, error.message)
      return Promise.reject(error)
    }
  )

export default instance