import axios, { AxiosRequestConfig, AxiosResponse } from 'axios'
import instance from './axios'

// 封装基础请求方法
const request = {
  get<T = any>(url: string, config?: AxiosRequestConfig): Promise<T> {
    return instance.get(url, config)
  },

  post<T = any>(
    url: string,
    data?: any,
    config?: AxiosRequestConfig
  ): Promise<T> {
    return instance.post(url, data, config)
  },

  put<T = any>(url: string, data?: any, config?: AxiosRequestConfig): Promise<T> {
    return instance.put(url, data, config)
  },

  delete<T = any>(url: string, config?: AxiosRequestConfig): Promise<T> {
    return instance.delete(url, config)
  }
}

// 开发环境启用 Mock
if (process.env.NODE_ENV !== 'production') {
  require('../mock') // 你的 Mock 配置文件
}


export default request