import React, { use } from "react";
import { Outlet } from "react-router";
import { useEffect, useState } from "react";
import { 
    SearchOutlined, 
    FontSizeOutlined, 
    MessageOutlined, 
    SunOutlined, 
    MoonOutlined
 } from "@ant-design/icons";
import style from "./frame.module.css";
import logo from "&/assets/logo.png";
import { useAppDispatch } from "@/hooks/store";
import { useSelector } from "react-redux";
import { checkAndRefreshToken } from "@/utils/jwt";
import { useNavigate } from "react-router-dom";
const Frame:React.FC = () => {

    useEffect(() => {
        checkAndRefreshToken();
    }, []);
    const dispatch = useAppDispatch();

    const showSearch = useSelector((state: any) => state.setting.showSearch); 
    const theme= useSelector((state: any) => state.setting.theme);
    
    const navigate = useNavigate(); // ✅ 用于跳转
    const [searchText, setSearchText] = useState(""); // ✅ 存储搜索输入内容


    const toggleSearch = () => {
        dispatch({ type: "setting/toggleSearch" });
    }

    const toggleFontSize = () => {
        dispatch({ type: "setting/toggleFontSize" });
    };

    const toggleTheme = () => {
        dispatch({ type: "setting/toggleTheme" });
    };

    // ✅ 用于跳转
    const handleSearch = (e: React.KeyboardEvent<HTMLInputElement>) => {
        if (e.key === "Enter" && searchText.trim() !== "") {
            navigate(`/search?keyword=${encodeURIComponent(searchText.trim())}`);
        }
    };


    return (
        <div style={{ display: 'block', height: '100vh' }}>
            <header className={style.header}>
                <img className={style.logo} src={logo} alt="website logo" onClick={()=>navigate('/')}></img>
                {showSearch && (
                    // <input className={style.searchInput} placeholder="输入关键词进行搜索"/>
                    <input
                        className={style.searchInput}
                        placeholder="输入关键词进行搜索"
                        value={searchText}
                        onChange={(e) => setSearchText(e.target.value)}
                        onKeyDown={handleSearch} // ⌨️ 按下回车时执行跳转
                    />)}
                <div className={style.toollist}>
                    <SearchOutlined onClick={toggleSearch}/>
                    <FontSizeOutlined onClick={toggleFontSize}/>
                    <MessageOutlined />
                    {theme === 'dark' ? <MoonOutlined onClick={toggleTheme}/> : <SunOutlined onClick={toggleTheme}/>}
                </div>
            </header>
            <div className={style.container}>
                <Outlet/>
            </div>
            
            
        </div>
    );
}

export default Frame;