import { PositionType } from 'antd/es/image/style';
import request from '@/utils/request';
import { useApi } from '@/hooks/request';
import React from 'react';
import { useNavigate } from 'react-router';
import { postFollowUser } from '@/api/user';
interface PosterInfoProps {
    userId: number;
    userName: string;
    role:string;
    avatar: string;
}

const PosterInfo: React.FC<PosterInfoProps> = (prop:PosterInfoProps) => {
    const nav = useNavigate();
    const { refresh } = useApi(()=>request.post(postFollowUser+`userId=${prop.userId}`), false);
    const handleClick = () => {
        nav(`/homepage?userId=${prop.userId}`);
    }

    const handleFollow = () => {
        refresh()
    }
    const { userId, userName, role, avatar } = prop;
    return (
        <>
            <div className="poster-info" onClick={handleClick}>
                <img src={avatar}></img>
                <p>{userName}</p>
                <p>{role}</p>
            </div>
            <button className="poster-info-button" />关注

        </>

    );
}