import React from 'react';
import { render, screen, waitFor } from '@testing-library/react';
import '@testing-library/jest-dom';
import Homepage from '@/views/homepage/homepage';
import { useApi } from '@/hooks/request';
import { useSelector } from 'react-redux';
import { useNavigate } from 'react-router';

jest.mock('@/hooks/request', () => ({
  useApi: jest.fn(),
}));

jest.mock('react-redux', () => ({
  useSelector: jest.fn(),
}));

jest.mock('react-router', () => ({
  useNavigate: jest.fn(),
}));

const mockUseApi = useApi as jest.MockedFunction<typeof useApi>;
const mockUseSelector = useSelector as jest.MockedFunction<typeof useSelector>;
const mockUseNavigate = useNavigate as jest.MockedFunction<typeof useNavigate>;

describe('Homepage Component', () => {
  const mockRefresh = jest.fn();
  const mockNavigate = jest.fn();

  beforeEach(() => {
    mockUseNavigate.mockReturnValue(mockNavigate);
    mockUseSelector.mockImplementation((selector) =>
      selector({ user: { avatar: 'https://example.com/avatar.jpg' } })
    );

    mockUseApi.mockReturnValue({
      data: {
        username: '测试用户',
        inviteCode: '123456',
        stats: {
          likes: 99,
          following: 10,
          followers: 20,
          mutualFollows: 5,
        },
        upload: '15',
        level: 'Lv3',
        works: [
          {
            postId: 2,
            userId: 0,
            postTitle: '凡高',
            postContent: '',
            createdAt: 0,
            postType: '',
            viewCount: 100,
            hotScore: 0.0,
            lastCalculated: 0
          },
        ],
        petImage: '',
        trafficImage: '',
      },
      loading: false,
      error: null,
      refresh: mockRefresh,
    });
  });

  afterEach(() => {
    jest.clearAllMocks();
  });

  it('renders user stats and works correctly', async () => {
    render(<Homepage />);

    await waitFor(() => {
      expect(screen.getByText('获赞')).toBeInTheDocument();
      expect(screen.getByText('99')).toBeInTheDocument();

      expect(screen.getByText('关注')).toBeInTheDocument();
      expect(screen.getByText('10')).toBeInTheDocument();

      expect(screen.getByText('粉丝')).toBeInTheDocument();
      expect(screen.getByText('20')).toBeInTheDocument();

      expect(screen.getByText('互关')).toBeInTheDocument();
      expect(screen.getByText('5')).toBeInTheDocument();

      expect(screen.getByText('您的总上传量为：')).toBeInTheDocument();
      expect(screen.getByText('15')).toBeInTheDocument();

      expect(screen.getByText('您的用户等级为：')).toBeInTheDocument();
      expect(screen.getByText('Lv3')).toBeInTheDocument();

      expect(screen.getByText('我的作品')).toBeInTheDocument();
      expect(screen.getByText('凡高')).toBeInTheDocument();
      expect(screen.getByText(/发布时间：0/)).toBeInTheDocument();
      expect(screen.getByText(/下载量：100 做种数：待定/)).toBeInTheDocument();
    });
  });
});
